
'use client';

import { Header } from '@/components/header';
import { Footer } from '@/components/footer';
import { AnimatedWrapper } from '@/components/animated-wrapper';
import { ConsortiumInfo } from '@/components/consortium-info';
import AboutUsSection from '@/components/about-us-section';
import WhyChooseUs from '@/components/why-choose-us';
import { Partners } from '@/components/partners';
import NoorEnergySection from '@/components/noor-energy-section';

export default function AboutPage() {
  return (
    <div className="flex min-h-screen flex-col bg-background pt-20">
      <Header />
      <main className="flex-1">
        <div className="container mx-auto space-y-24 px-4 py-16 sm:space-y-32 sm:py-24">
          <AnimatedWrapper>
            <ConsortiumInfo />
          </AnimatedWrapper>
          <AnimatedWrapper>
            <AboutUsSection />
          </AnimatedWrapper>
          <AnimatedWrapper>
            <NoorEnergySection />
          </AnimatedWrapper>
          <AnimatedWrapper>
            <WhyChooseUs />
          </AnimatedWrapper>
          <AnimatedWrapper>
            <Partners />
          </AnimatedWrapper>
        </div>
      </main>
      <Footer />
    </div>
  );
}
